#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Byt3-daily-012Mod01.fsh     by      byt3_m3chanic
//https://www.shadertoy.com/view/4clBDX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** 

    License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
    
    Inspired by @Shanes' recent shaders, just trying to figure the hexagon/cube thing.

    Byt3-daily-012
    08/23/2024  @byt3_m3chanic
    
*/

#define R     iResolution
#define T     iTime
#define M     iMouse

#define PI    3.141592653
#define PI2   6.283185307

float hash21(vec2 a) { return fract(sin(dot(a, vec2(27.609, 57.583)))*43758.5453); }
mat2 rot(float a) { return mat2(cos(a),sin(a),-sin(a),cos(a)); }

// Hexagon grid system, can be simplified but
// written out long-form for readability. 
// return vec2 uv and vec2 id
vec4 hexgrid(vec2 uv) {
    vec2 p1 = floor(uv/vec2(1.732,1))+.5;
    vec2 p2 = floor((uv-vec2(1,.5))/vec2(1.732,1))+.5;
    
    vec2 h1 = uv-p1*vec2(1.732,1);
    vec2 h2 = uv-(p2+.5)*vec2(1.732,1);
    return dot(h1,h1) < dot(h2,h2) ? vec4(h1,p1) : vec4(h2,p2+.5);
}

vec3 hsv( vec3 a ) {
    vec3 c = a + vec3(T*.1,0,0);
    vec3 rgb = clamp(abs(mod(c.x*2.+vec3(0,4,2),6.)-3.)-1.,0.,1.);
    return c.z * mix(vec3(1),rgb,c.y);
}

float truch(vec2 uv, vec2 id) {
    vec2 vv = uv;
    vec2 vd = floor(vv*10.);
    vv = fract(vv*10.)-.5;

    float rnd = hash21(vd+id);
    if(rnd>.5) vv.x = -vv.x;
    
    vec2 q = length(vv+.5)<length(vv-.5)? vv+.5:vv-.5;
    
    float d = abs(length(q)-.5)-.15;
    if(fract(rnd*43.57)>.77) d = min(length(vv.x)-.125,length(vv.y)-.125);
    
    return d;
}

void cube(inout vec3 C, vec2 uv, vec2 id, float px, float rnd, float lvl) {

    float ln = .015, hn = ln/2.;
    float rd = hash21(lvl+id*32.23);
    float hs = rd>.3?1.155:.65+.55*sin((rnd*PI2)+T*1.33);
    
    float d = max(abs(uv.x)*.866025 + abs(uv.y)/2., abs(uv.y))-(hs*.42);
    C = mix(C,vec3(0),smoothstep(px,-px,abs(d)-ln));
    
    uv.x -= (hs*.515);
    float tbase =length( abs(uv.x)*.866025 + abs(uv.y)/2.)- (hs*.445);
    
    float e = min(tbase, length(uv.y));
    
    rnd = fract(rnd*52.47);
    rnd += lvl*1.5;
    
    // color sides
    C = mix(C,hsv(vec3(rnd,.5,.8)),smoothstep(px,-px,max(tbase,d)) );
    C = mix(C,hsv(vec3(rnd+.15,1,.4)),smoothstep(px,-px,max(max(uv.y,-tbase),d)) );
    C = mix(C,hsv(vec3(rnd+.75,1,.2)),smoothstep(px,-px,max(max(max(-uv.y,uv.x),-tbase),d)) );

    if(lvl>1.&&fract(rd*52.47)>.36)C = mix(C,C*.25,smoothstep(px,-px,length(uv+vec2(.5,0)*hs)-(hs*.35)));
    
    // truchet patterns
    vec2 vv = vec2(uv.x*.866025,uv.y/2.);
    // math is kind of jank - wasnt sure how to properly do this so 
    // a lot of hunt and peck values
    id+=floor(rnd*15.);
    // top side
    vv.x += .51;
    vv *= rot(.78);
    float t = truch(vv*1.2,id);
    if(rd>.3) C = mix(C,clamp(C+.25,vec3(0),vec3(1)),smoothstep(px,-px,max(max(tbase,d),t)) );
    
    // left side
    vv = vec2(uv.x*.866025,uv.y/1.33)+vec2(uv.y*.5,0);
    vv.x += .65;
    t = truch(vv*vec2(.9,1.1),id);
    if(rd>.3)C = mix(C,clamp(C+.15,vec3(0),vec3(1)),smoothstep(px,-px,max(max(uv.y,max(d,-tbase)),t) ) );
    
    // right side
    vv = vec2(uv.x*.866025,uv.y/1.33)-vec2(uv.y*.5,0);
    vv.x += .65;
    t = truch(vv*vec2(.9,1.1),id);
    if(rd>.3)C = mix(clamp(C-.15,vec3(0),vec3(1)),C,smoothstep(px,-px,max(max(max(-uv.y,uv.x),-tbase),t)) );

    C = mix(C,vec3(0),smoothstep(px,-px,max(abs(e)-hn,d)));

}

const float scale = 5.;
const float mx = 3.;
const float mz = mx-1.;
#define F fragCoord
//void mainImage( out vec4 fragColor, in vec2 F )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 C = vec3(0);
    vec2 uv = (2.*F-R.xy)/max(R.x,R.y);
    float px = fwidth(uv.x);
    
    uv *= scale;
    uv.y += T*.065;
    
    vec4 H;
    vec2 p, id;
    float rnd;
    
    // layer stack loop - smallest to large
    for(float i=0.;i<mx;i++) {
        float sc = mx-i;
        
        H = hexgrid(uv.yx*sc);
        p = H.xy, id = H.zw;
        rnd = hash21(id+i); 
        if(rnd>.25) cube(C,p,id,px,rnd,i+.5);
        if(i<mz) C *= (i+.5)*.25;
        uv.y += T*.125;
    }
    
    fragColor = vec4(pow(C,vec3(.4545)),1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

